from collections import deque

def find_number_of_buses(bus_lines, start_station, end_station):
    queue = deque()
    visited_stations = set()

    queue.append(start_station)
    visited_stations.add(start_station)

    bus_counter = 0

    while queue:
        stations_in_current_bus = len(queue)

        for _ in range(stations_in_current_bus):
            current_station = queue.popleft()

            if current_station == end_station:
                return bus_counter

            for neighbor_station in bus_lines[current_station]:
                if neighbor_station not in visited_stations:
                    queue.append(neighbor_station)
                    visited_stations.add(neighbor_station)

        bus_counter += 1

    return -1

def main():
    first_line = input().split()
    N, M, S, T = map(int, first_line)

    bus_lines = {}

    for _ in range(M):
        line = input().split()
        station_a, station_b = map(int, line)

        bus_lines.setdefault(station_a, []).append(station_b)
        bus_lines.setdefault(station_b, []).append(station_a)

    number_of_buses = find_number_of_buses(bus_lines, S, T)

    print(number_of_buses)

if __name__ == "__main__":
    main()