#include <stdio.h>
#include <stdlib.h>

#define MAX_N 100
#define INF 1e9

int min(int a, int b) {
    return a < b ? a : b;
}

int main() {
    int N, M, S, T;
    scanf("%d %d %d %d", &N, &M, &S, &T);

    int graph[MAX_N][MAX_N];
    for (int i = 0; i < MAX_N; i++) {
        for (int j = 0; j < MAX_N; j++) {
            graph[i][j] = INF;
        }
    }

    for (int i = 0; i < M; i++) {
        int U, V;
        scanf("%d %d", &U, &V);
        graph[U][V] = graph[V][U] = 1;
    }
    for (int k = 1; k <= N; k++) {
        for (int i = 1; i <= N; i++) {
            for (int j = 1; j <= N; j++) {
                graph[i][j] = min(graph[i][j], graph[i][k] + graph[k][j]);
            }
        }
    }
    int minBuses = INF;
    for (int i = 1; i <= N; i++) {
        minBuses = min(minBuses, graph[S][i] + graph[i][T]);
    }
    printf("%d\n", minBuses - 1);
    return 0;
}