#include <iostream>
#include <vector>
#include <queue>
#include <unordered_set>

using namespace std;

/// Funkcija za trazenje koliko busa je potrebno (bfs)
int findMinBuses(int N, int M, int S, int T, vector<vector<int>>& StariPlan) {

    vector<vector<int>> intermediateStations(N + 1);
    for (int i = 0; i < M; ++i) {
        int U = StariPlan[i][0];
        int V = StariPlan[i][1];
        intermediateStations[U].push_back(V);
        intermediateStations[V].push_back(U);
    }

    vector<vector<int>> newPlan(N + 1);
    for (int i = 1; i <= N; ++i) {
        for (int j : intermediateStations[i]) {
            for (int k : intermediateStations[j]) {
                if (k != i) {
                    newPlan[i].push_back(k);
                }
            }
        }
    }

    queue<int> q;
    unordered_set<int> visited;

    q.push(S);
    visited.insert(S);

    vector<int> busesUsed(N + 1, 0);

    while (!q.empty()) {
        int currentStation = q.front();
        q.pop();


        for (int neighbor : newPlan[currentStation]) {
            if (visited.find(neighbor) == visited.end()) {

                visited.insert(neighbor);
                busesUsed[neighbor] = busesUsed[currentStation] + 1;
                q.push(neighbor);
            }
        }
    }

    return busesUsed[T];
}

int main()
{
    int N, M, S, T;
    cin >> N >> M >> S >> T;

    vector<vector<int>> StariPlan(M, vector<int>(2));
    for (int i = 0; i < M; ++i) {
        cin >> StariPlan[i][0] >> StariPlan[i][1];
    }

    int rezultat = findMinBuses(N, M, S, T, StariPlan);
    cout << rezultat << endl;

    return 0;
}