using System;
using System.Collections.Generic;
class Program
{
    static void Main()
    {
        string[] input = Console.ReadLine().Split();
        int N = int.Parse(input[0]);
        int M = int.Parse(input[1]);
        int S = int.Parse(input[2]);
        int T = int.Parse(input[3]);
        Dictionary<int, List<int>> graf = new Dictionary<int, List<int>>();
        for (int i = 0; i < M; i++)
        {
            input = Console.ReadLine().Split();
            int U = int.Parse(input[0]);
            int V = int.Parse(input[1]);

            if (!graf.ContainsKey(U))
                graf[U] = new List<int>();

            if (!graf.ContainsKey(V))
                graf[V] = new List<int>();

            graf[U].Add(V);
            graf[V].Add(U);
        }
        int minAutobusa = NadjiMinAutobusa(graf, S, T);
        Console.WriteLine(minAutobusa);
    }
    static int NadjiMinAutobusa(Dictionary<int, List<int>> graf, int pocetak, int kraj)
    {
        Queue<int> red = new Queue<int>();
        HashSet<int> poseceni = new HashSet<int>();
        red.Enqueue(pocetak);
        poseceni.Add(pocetak);
        int autobusi = 0;
        while (red.Count > 0)
        {
            int velicina = red.Count;
            for (int i = 0; i < velicina; i++)
            {
                int trenutna = red.Dequeue();
                if (trenutna == kraj)
                    return autobusi;

                foreach (int sused in graf[trenutna])
                {
                    if (!poseceni.Contains(sused))
                    {
                        red.Enqueue(sused);
                        poseceni.Add(sused);
                    }
                }
            }
            autobusi++;
        }
        return -1;
    }
}