using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace k1
{
    internal class Program
    {
        static List<int>[] g;
        static int FindFastestPath(int pocetak, int kraj)
        {
            if (pocetak == kraj)
            {
                return 0;
            }
            List<int> put = new List<int>();
            Queue<int> queue = new Queue<int>();
            HashSet<int> predjeni = new HashSet<int>();
            Dictionary<int, int> roditelj = new Dictionary<int, int>();

            queue.Enqueue(pocetak);
            predjeni.Add(pocetak);

            while (queue.Count > 0)
            {
                int current = queue.Dequeue();

                foreach (int neighbor in g[current])
                {
                    if (!predjeni.Contains(neighbor))
                    {
                        queue.Enqueue(neighbor);
                        predjeni.Add(neighbor);
                        roditelj[neighbor] = current;

                        if (neighbor == kraj)
                        {
                            put.Add(kraj);
                            while (current != pocetak)
                            {
                                put.Insert(0, current);
                                current = roditelj[current];
                                
                            }
                            if (put.Count % 2 == 0) {
                                return put.Count / 2;
                            }

                        }
                    }
                }
            }
            return 0;
            

        }
        static void Main(string[] args)
        {
            string[] s = Console.ReadLine().Split();
            int N = int.Parse(s[0]);
            int M = int.Parse(s[1]);
            int S = int.Parse(s[2]);
            int R = int.Parse(s[3]);
            g = new List<int>[N + 1];
            for (int i = 0; i < M; i++)
            {
                s = Console.ReadLine().Split();
                int u = int.Parse(s[0]);
                int v = int.Parse(s[1]);
                if (g[v] == null) { g[v] = new List<int>(); }
                g[v].Add(u);
                if (g[u] == null) { g[u] = new List<int>(); }
                g[u].Add(v);
            }
            Console.WriteLine(FindFastestPath(S, R));
            Console.ReadLine();

        }
    }
}