#include <iostream>

void optimizeGraph(bool graph[][10000], int n) {

    bool optimizedGraph[n][n];

    for(int i = 0; i < n; i++) {
        for(int j = 0; j < n; j++) {
            optimizedGraph[i][j] = false;
        }
    }

    for(int i = 0; i < n; i++) {
        for(int j = 0; j < n; j++) {
            if(graph[i][j] == true) {
                for(int k = 0; k < n; k++) {
                    if(graph[j][k] == true) {
                        optimizedGraph[i][k] = true;
                    }
                }
            }
        }
    }

    for(int i = 0; i < n; i++) {
        for(int j = 0; j < n; j++) {
            graph[i][j] = optimizedGraph[i][j];
        }
    }

}

int main() {

    int n, m, s, t;

    std::cin >> n >> m >> s >> t;

    bool linksGraph[n][10000];

    for(int i = 0; i < n; i++) {
        for(int j = 0; j < n; j++) {
            linksGraph[i][j] = false;
        }
    }

    for(int i = 0; i < m; i++) {
        int u, v;
        std::cin >> u >> v;

        linksGraph[u-1][v-1] = true;
        linksGraph[v-1][u-1] = true;
    }

    int res = 0;
    while(linksGraph[s-1][t-1] == false) {
        optimizeGraph(linksGraph, n);
        res++;
    }

    std::cout << res << std::endl;

    return 0;
}