using System;
using System.Collections.Generic;

class ShortestPathBFS
{
    // Funkcija za kreiranje grafa na osnovu ulaznih veza
    static Dictionary<int, List<int>> CreateGraph(int[,] edges)
    {
        Dictionary<int, List<int>> graph = new Dictionary<int, List<int>>();

        for (int i = 0; i < edges.GetLength(0); i++)
        {
            int u = edges[i, 0];
            int v = edges[i, 1];

            if (!graph.ContainsKey(u))
                graph[u] = new List<int>();

            if (!graph.ContainsKey(v))
                graph[v] = new List<int>();

            graph[u].Add(v);
            graph[v].Add(u);
        }

        return graph;
    }

    // Funkcija koja pronalazi najkraci put izmedu dve tacke koristeci BFS
    static int ShortestPath(Dictionary<int, List<int>> graph, int start, int end)
    {
        HashSet<int> visited = new HashSet<int>();
        Queue<(int, int)> queue = new Queue<(int, int)>();
        queue.Enqueue((start, 0));

        while (queue.Count > 0)
        {
            (int current, int distance) = queue.Dequeue();
            visited.Add(current);

            if (current == end)
                return distance;

            foreach (int neighbor in graph[current])
            {
                if (!visited.Contains(neighbor))
                {
                    queue.Enqueue((neighbor, distance + 1));
                }
            }
        }

        return int.MaxValue; // Ako ne postoji put izmedu tacaka
    }

    static void Main()
    {   
        
    int n, m, s, t;
    string[] k = Console.ReadLine().Split();
    n = int.Parse(k[0]);
    m = int.Parse(k[1]);
    s = int.Parse(k[2]);
    t = int.Parse(k[3]);
    int[,] edges = new int[m, 2];
    for (int i = 0; i < m; i++)
    {
        string[] k1 = Console.ReadLine().Split();
        edges[i, 0] = int.Parse(k1[0]);
        edges[i, 1] = int.Parse(k1[1]);
    }

        // Kreiranje grafa
        Dictionary<int, List<int>> graph = CreateGraph(edges);

        // Pocetna i krajnja tacka
        int start = s;
        int end = t;

        // Pronalaženje najkraceg puta izmedu pocetne i krajnje tacke
        int shortestDistance = ShortestPath(graph, start, end);

        Console.WriteLine(shortestDistance/2);
    }
}