using System;
using System.Collections.Generic;

class ShortestPathBFS
{
    // Funkcija za kreiranje grafa na osnovu ulaznih veza
    static Dictionary<int, List<int>> CreateGraph(int[,] edges)
    {
        Dictionary<int, List<int>> graph = new Dictionary<int, List<int>>();

        for (int i = 0; i < edges.GetLength(0); i++)
        {
            int u = edges[i, 0];
            int v = edges[i, 1];

            if (!graph.ContainsKey(u))
                graph[u] = new List<int>();

            if (!graph.ContainsKey(v))
                graph[v] = new List<int>();

            graph[u].Add(v);
            graph[v].Add(u);
        }

        return graph;
    }

    // Funkcija koja pronalazi najkraci put izmedu dve tacke koristeci BFS
    static int ShortestPath(Dictionary<int, List<int>> graph, int start, int end)
    {
        HashSet<int> visited = new HashSet<int>();
        Queue<int[]> queue = new Queue<int[]>();
        queue.Enqueue(new int[] { start, 0 });

        while (queue.Count > 0)
        {
            int[] current = queue.Dequeue();
            int currentNode = current[0];
            int distance = current[1];
            visited.Add(currentNode);

            if (currentNode == end)
                return distance;

            foreach (int neighbor in graph[currentNode])
            {
                if (!visited.Contains(neighbor))
                {
                    queue.Enqueue(new int[] { neighbor, distance + 1 });
                }
            }
        }

        return int.MaxValue; // Ako ne postoji put izmedu tacaka
    }

    static void Main()
    {
    int n, m, s, t;
    string[] k = Console.ReadLine().Split();
    n = int.Parse(k[0]);
    m = int.Parse(k[1]);
    s = int.Parse(k[2]);
    t = int.Parse(k[3]);
    int[,] a = new int[m, 2];
    for (int i = 0; i < m; i++)
    {
        string[] k1 = Console.ReadLine().Split();
        a[i, 0] = int.Parse(k1[0]);
        a[i, 1] = int.Parse(k1[1]);
}
        Dictionary<int, List<int>> graph = CreateGraph(a);

        
        int start = s;
        int end = t;

        // Pronalaženje najkraceg puta izmedu pocetne i krajnje tacke
        int shortestDistance = ShortestPath(graph, start, end);

        Console.WriteLine(shortestDistance/2);
    }
}