#include <bits/stdc++.h>

using namespace std;

void bfs(const vector<vector<int>>& graph, vector<int>& distance, int start) {
    queue<int> q;
    q.push(start);
    distance[start] = 0;

    while (!q.empty()) {
        int current = q.front();
        q.pop();

        for (int neighbor : graph[current]) {
            if (distance[neighbor] == -1) {
                distance[neighbor] = distance[current] + 1;
                q.push(neighbor);
            }
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);

    int x, y;
    cin >> x >> y;


    int start, ende;
    cin >> start >> ende;
    start --;
    ende --;

    vector<vector<int>> graph(x);

    for (int i = 0; i < y; ++i) {
        int a, b;
        cin >> a >> b;
        a --;
        b --;
        graph[a].push_back(b);
        graph[b].push_back(a);
    }


    vector<int> distance(x, -1);
    bfs(graph, distance, start);

    cout << distance[ende] / 2 + distance[ende] % 2 << "\n";

    return 0;
}