#include <bits/stdc++.h>

using namespace std;

void bfs(const vector<vector<int>>& graph, vector<int>& distanca, int start) {
    queue<int> q;
    q.push(start);
    distanca[start] = 0;

    while (!q.empty()) {
        int trenutno = q.front();
        q.pop();

        for (int komsija : graph[trenutno]) {
            if (distanca[komsija] == -1) {
                distanca[komsija] = distanca[trenutno] + 1;
                q.push(komsija);
            }
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);

    int x, y;
    cin >> x >> y;


    int start, ende;
    cin >> start >> ende;
    start --;
    ende --;

    vector<vector<int>> graph(x);

    for (int i = 0; i < y; ++i) {
        int a, b;
        cin >> a >> b;
        a --;
        b --;
        graph[a].push_back(b);
        graph[b].push_back(a);
    }


    vector<int> distanca(x, -1);
    bfs(graph, distanca, start);

    cout << distanca[ende] / 2 + distanca[ende] % 2 << "\n";

    return 0;
}