#include <iostream>
#include <vector>
#include <queue>
#include <unordered_set>

using namespace std;

// Funkcija za konstrukciju grafa na osnovu povezanosti stanica
void konstruisiGraf(int N, int M, vector<vector<int>>& graf, const vector<pair<int, int>>& povezanosti) {
    for (const auto& povezanost : povezanosti) {
        graf[povezanost.first].push_back(povezanost.second);
        graf[povezanost.second].push_back(povezanost.first);
    }
}

// Funkcija za racunanje minimalnog broja autobusa
int minAutobusa(int N, int M, int S, int T, const vector<pair<int, int>>& povezanosti) {
    vector<vector<int>> graf(N + 1);  // Graf predstavljen listom suseda
    konstruisiGraf(N, M, graf, povezanosti);

    unordered_set<int> poseceno;
    queue<int> red;  // Red za BFS
    red.push(S);

    int autobusi = 0;
    while (!red.empty()) {
        int velicina = red.size();
        for (int i = 0; i < velicina; ++i) {
            int trenutna = red.front();
            red.pop();

            if (trenutna == T) {
                return autobusi;
            }

            poseceno.insert(trenutna);

            for (int sused : graf[trenutna]) {
                if (poseceno.find(sused) == poseceno.end()) {
                    red.push(sused);
                }
            }
        }
        autobusi++;
    }

    return -1;  // Ako ne postoji put do cilja
}

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;

    vector<pair<int, int>> povezanosti(M);
    for (int i = 0; i < M; ++i) {
        cin >> povezanosti[i].first >> povezanosti[i].second;
    }

    int rezultat = minAutobusa(N, M, S, T, povezanosti)/2;
    cout << rezultat << endl;

    return 0;
}