#include <stdio.h>
#include <stdlib.h>

// Struktura koja predstavlja cvor u grafu
struct Node {
    int data;
    struct Node* next;
};

// Struktura koja predstavlja listu povezanosti za svaku stanicu
struct Graph {
    int V; // Broj cvorova (stanica)
    struct Node** adjacencyList;
};

// Funkcija za dodavanje grane izmedu dve stanice u grafu
void addEdge(struct Graph* graph, int src, int dest) {
    struct Node* newNode = (struct Node*)malloc(sizeof(struct Node));
    newNode->data = dest;
    newNode->next = graph->adjacencyList[src];
    graph->adjacencyList[src] = newNode;

    // Dodajemo i grane u suprotnom smeru jer je linija dvosmerna
    newNode = (struct Node*)malloc(sizeof(struct Node));
    newNode->data = src;
    newNode->next = graph->adjacencyList[dest];
    graph->adjacencyList[dest] = newNode;
}

// Funkcija za pretragu puta od S do T
int BFS(struct Graph* graph, int start, int end) {
    if (start == end) return 0;

    int* visited = (int*)malloc((graph->V) * sizeof(int));
    for (int i = 0; i < graph->V; i++) {
        visited[i] = 0;
    }

    int* queue = (int*)malloc((graph->V) * sizeof(int));
    int* dist = (int*)malloc((graph->V) * sizeof(int));

    int front = 0, rear = 0;
    queue[rear++] = start;
    visited[start] = 1;
    dist[start] = 0;

    while (front < rear) {
        int current = queue[front++];
        struct Node* temp = graph->adjacencyList[current];

        while (temp != NULL) {
            int neighbor = temp->data;
            if (!visited[neighbor]) {
                visited[neighbor] = 1;
                dist[neighbor] = dist[current] + 1;
                queue[rear++] = neighbor;

                if (neighbor == end) {
                    free(visited);
                    free(queue);
                    free(dist);
                    return dist[neighbor];
                }
            }
            temp = temp->next;
        }
    }

    free(visited);
    free(queue);
    free(dist);
    return -1; // Put nije pronaden
}

int main() {
    int N, M;
    scanf("%d", &N);

    struct Graph* graph = (struct Graph*)malloc(sizeof(struct Graph));
    graph->V = N + 1; // Dodajemo 1 jer stanice idu od 1 do N
    graph->adjacencyList = (struct Node**)malloc((graph->V) * sizeof(struct Node*));

    for (int i = 0; i <= N; i++) {
        graph->adjacencyList[i] = NULL;
    }

    scanf("%d", &M);

    for (int i = 0; i < M; i++) {
        int u, v;
        scanf("%d %d", &u, &v);
        addEdge(graph, u, v);
    }

    int S, T;
    scanf("%d %d", &S, &T);

    int minBuses = BFS(graph, S, T);
    printf("%d\n", minBuses);

    // Oslobadanje memorije
    for (int i = 0; i <= N; i++) {
        struct Node* current = graph->adjacencyList[i];
        while (current != NULL) {
            struct Node* next = current->next;
            free(current);
            current = next;
        }
    }
    free(graph->adjacencyList);
    free(graph);

    return 0;
}