using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static Dictionary<int, List<int>> BuildGraph(int N, int M, int[,] pairs)
    {
        var graph = new Dictionary<int, List<int>>();
        
        for (int i = 0; i < M; i++)
        {
            int u = pairs[i, 0];
            int v = pairs[i, 1];
            
            if (!graph.ContainsKey(u))
                graph[u] = new List<int>();
            if (!graph.ContainsKey(v))
                graph[v] = new List<int>();
            
            graph[u].Add(v);
            graph[v].Add(u);
        }
        
        return graph;
    }

    static int MinBuses(int N, int M, int S, int T, int[,] pairs)
    {
        var graph = BuildGraph(N, M, pairs);
        var visited = new HashSet<int>();
        var queue = new Queue<(int, int)>(); // (station, busesUsed)
        
        queue.Enqueue((S, 0));
        
        while (queue.Count > 0)
        {
            var (currentStation, busesUsed) = queue.Dequeue();
            
            if (currentStation == T)
                return busesUsed;
            
            visited.Add(currentStation);
            
            foreach (var neighbor in graph[currentStation])
            {
                if (!visited.Contains(neighbor))
                {
                    queue.Enqueue((neighbor, busesUsed + 1));
                }
            }
        }
        
        return -1;
    }

    static void Main()
    {
   
        var input = Console.ReadLine().Split().Select(int.Parse).ToArray();
        int N = input[0];
        int M = input[1];
        int S = input[2];
        int T = input[3];

        var pairs = new int[M, 2];

        for (int i = 0; i < M; i++)
        {
            var pair = Console.ReadLine().Split().Select(int.Parse).ToArray();
            pairs[i, 0] = pair[0];
            pairs[i, 1] = pair[1];
        }

        int result = MinBuses(N, M, S, T, pairs);
        Console.WriteLine(result);
    }
}