#include <iostream>
#include <vector>
#include <queue>

using namespace std;

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;

    vector<vector<int>> adj(N + 1);  // Lista susjedstva
    vector<int> visited(N + 1, false);

    for (int i = 0; i < M; ++i) {
        int U, V;
        cin >> U >> V;
        adj[U].push_back(V);
        adj[V].push_back(U);
    }

    queue<int> q;
    vector<int> dist(N + 1, -1);

    q.push(S);
    dist[S] = 0;

    while (!q.empty()) {
        int current = q.front();
        q.pop();

        for (int neighbor : adj[current]) {
            if (dist[neighbor] == -1) {
                dist[neighbor] = dist[current] + 1;
                q.push(neighbor);
            }
        }
    }

    cout << dist[T] << endl;

    return 0;
}