using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        string[] unos = Console.ReadLine().Split();
        int N = int.Parse(unos[0]);
        int M = int.Parse(unos[1]);
        int S = int.Parse(unos[2]);
        int T = int.Parse(unos[3]);

        Dictionary<int, List<int>> graf = new Dictionary<int, List<int>>();

        for (int i = 0; i < M; i++)
        {
            string[] par = Console.ReadLine().Split();
            int U = int.Parse(par[0]);
            int V = int.Parse(par[1]);

            if (!graf.ContainsKey(U))
                graf[U] = new List<int>();

            if (!graf.ContainsKey(V))
                graf[V] = new List<int>();

            graf[U].Add(V);
            graf[V].Add(U);
        }

        int rezultat = MinBrojAutobusa(graf, N, S, T);
        Console.WriteLine(rezultat/2);
    }

    static int MinBrojAutobusa(Dictionary<int, List<int>> graf, int N, int S, int T)
    {
        Queue<int> red = new Queue<int>();
        HashSet<int> poseceno = new HashSet<int>();

        red.Enqueue(S);
        poseceno.Add(S);

        int brojAutobusa = 0;

        while (red.Count > 0)
        {
            int velicinaNivoa = red.Count;

            for (int i = 0; i < velicinaNivoa; i++)
            {
                int trenutni = red.Dequeue();

                if (trenutni == T)
                    return brojAutobusa;

                if (graf.ContainsKey(trenutni))
                {
                    foreach (int sused in graf[trenutni])
                    {
                        if (!poseceno.Contains(sused))
                        {
                            red.Enqueue(sused);
                            poseceno.Add(sused);
                        }
                    }
                }
            }

            brojAutobusa++;
        }

        return -1;
    }
}