using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main(string[] args)
    {
        // Ucitavanje ulaznih podataka
        string[] firstLine = Console.ReadLine().Split(' ');
        int N = int.Parse(firstLine[0]);
        int M = int.Parse(firstLine[1]);
        int S = int.Parse(firstLine[2]);
        int T = int.Parse(firstLine[3]);

        Dictionary<int, List<int>> graph = new Dictionary<int, List<int>>();

        for (int i = 0; i < M; i++)
        {
            string[] line = Console.ReadLine().Split(' ');
            int U = int.Parse(line[0]);
            int V = int.Parse(line[1]);

            if (!graph.ContainsKey(U))
                graph[U] = new List<int>();

            if (!graph.ContainsKey(V))
                graph[V] = new List<int>();

            graph[U].Add(V);
            graph[V].Add(U);
        }

        // Kreiranje novog grafa prema novim pravilima
        Dictionary<int, List<int>> newGraph = CreateNewGraph(graph, N);

        // Pronalazak najkraceg puta
        int minBuses = FindShortestPath(newGraph, S, T);

        Console.WriteLine(minBuses);
    }

    static Dictionary<int, List<int>> CreateNewGraph(Dictionary<int, List<int>> graph, int N)
    {
        Dictionary<int, List<int>> newGraph = new Dictionary<int, List<int>>();

        for (int i = 1; i <= N; i++)
        {
            newGraph[i] = new List<int>();
            for (int j = 1; j <= N; j++)
            {
                if (i != j && graph[i].Any(v => graph[j].Contains(v)))
                {
                    newGraph[i].Add(j);
                }
            }
        }

        return newGraph;
    }

    static int FindShortestPath(Dictionary<int, List<int>> graph, int start, int end)
    {
        Queue<int> queue = new Queue<int>();
        queue.Enqueue(start);

        Dictionary<int, int> distances = new Dictionary<int, int>();
        distances[start] = 0;

        while (queue.Count > 0)
        {
            int current = queue.Dequeue();

            foreach (var neighbor in graph[current])
            {
                if (!distances.ContainsKey(neighbor))
                {
                    distances[neighbor] = distances[current] + 1;
                    queue.Enqueue(neighbor);

                    if (neighbor == end)
                        return distances[neighbor];
                }
            }
        }

        return -1;
    }
}