#include <iostream>
#include <vector>
#include <queue>
#include <climits>
#include <cmath>
using namespace std;

int main()
{
	//unos vrednosti
    int N, M, S, T;
    cin >> N >> M >> S >> T;

    vector<int> U(M);
    vector<int> V(M);

    struct Stanica {
        vector<int> povezane;
        int broj_povezanih = 0;
    };

    Stanica stanica[N];

    for (int i = 0; i < M; i++)
    {
        cin >> U[i] >> V[i];
        stanica[U[i] - 1].povezane.push_back(V[i]);
        stanica[U[i] - 1].broj_povezanih++;

        stanica[V[i] - 1].povezane.push_back(U[i]);
        stanica[V[i] - 1].broj_povezanih++;
    }

	//odredjivanje potrebnog broja presedanja
    queue<int> q;
    vector<int> brojPromena(N, INT_MAX);

    q.push(S);
    brojPromena[S - 1] = 0;

    while (!q.empty())
    {
        int trenutnaStanica = q.front();
        q.pop();

        for (int i = 0; i < stanica[trenutnaStanica - 1].broj_povezanih; i++)
        {
            int susednaStanica = stanica[trenutnaStanica - 1].povezane[i];

            if (brojPromena[susednaStanica - 1] == INT_MAX)
            {
                brojPromena[susednaStanica - 1] = brojPromena[trenutnaStanica - 1] + 1;
                q.push(susednaStanica);
            }
        }
    }
    
	//ispis minimalnog broja presedanja, ako je on
    if (brojPromena[T - 1] == INT_MAX){
        return (0); 
    }
    else{
    	int broj = round(brojPromena[T - 1] / 2);
        cout << broj << endl; 
    }

    return 0;
}