#include <bits/stdc++.h>
#define ll long long
#define all(x) x.begin(), x.end()
using namespace std;

ll n, m, s, t;
vector<ll> dist;

void dijsktra(const vector<vector<ll>>& G) {
    vector<bool> visited(n+1, false);
    priority_queue<pair<ll, ll>, vector<pair<ll, ll>>, greater<pair<ll, ll>>> red;
    red.push({0, s});
    dist[s] = 0;
    while(!red.empty()) {
        ll s = red.top().second; red.pop();

        if(visited[s]) continue;
        visited[s] = true;

        for(auto u : G[s]) {
            if(dist[s] + 1 < dist[u]) {
                dist[u] = dist[s] + 1;
                red.push({dist[u], u});
            }
        }
    }
}

void solve() {
    cin >> n >> m >> s >> t;

    dist.resize(n+1, UINT_MAX);

    vector<vector<ll>> G(n+1);
    for(int i=0; i<m; i++) {
        ll a, b;
        cin >> a >> b;

        G[a].push_back(b);
        G[b].push_back(a);
    }

    dijsktra(G);

    cout << (dist[t] + 1) / 2 << endl;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0); cout.tie(0);

    //int t;
    //cin >> t;
    //while(t--) solve();

    solve();

    return 0;
}