#include <bits/stdc++.h>
#define ll long long
#define all(x) x.begin(), x.end()
using namespace std;

ll n, m, s, t;
vector<ll> dist;

void bfs(const vector<vector<ll>>& G) {
    vector<bool> visited(n+1, false);
    queue<ll> red;
    red.push(s);
    dist[s] = 0;
    visited[s] = true;
    while(!red.empty()) {
        ll s = red.front(); red.pop();

        for(auto u : G[s]) {
            if(visited[u]) continue;
            visited[u] = true;
            dist[u] = dist[s] + 1;
            red.push(u);
        }
    }
}

void solve() {
    cin >> n >> m >> s >> t;

    dist.resize(n+1);

    vector<vector<ll>> G(n+1);
    for(int i=0; i<m; i++) {
        ll a, b;
        cin >> a >> b;

        G[a].push_back(b);
        G[b].push_back(a);
    }

    bfs(G);

    cout << (dist[t] + 1) / 2 << endl;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0); cout.tie(0);

    //int t;
    //cin >> t;
    //while(t--) solve();

    solve();

    return 0;
}