#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>

using namespace std;

vector<vector<int>> novi(vector<vector<int>> stari_plan, int n) {
    vector<vector<int>> res(n);

    for (int i = 0; i < n; i++) {
        if (stari_plan[i].size() >= 2) {
            for (int j = 0; j < stari_plan[i].size() - 1; j++) {
                for (int k = j + 1; k < stari_plan[i].size(); k++) {
                    if (find(res[stari_plan[i][j]].begin(), res[stari_plan[i][j]].end(), stari_plan[i][k]) == res[stari_plan[i][j]].end()) {
                        res[stari_plan[i][j]].push_back(stari_plan[i][k]);
                        res[stari_plan[i][k]].push_back(stari_plan[i][j]);
                    } 
                }
            }
        } 
    }

    return res;
}

int main()
{
    int n, m, s, t;
    cin >> n >> m >> s >> t;

    s--;
    t--;

    vector<vector<int>> plan(n);

    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        plan[a - 1].push_back(b - 1);
        plan[b - 1].push_back(a - 1);
    }

    plan = novi(plan, n);

    vector<int> razdaljine(n);
    queue<int> cekanje;

    vector<bool> poseceni(n);
    for (int i = 0;i < n;i++) {
        poseceni[i] = false;
    }

    for (int i = 0; i < n; i++) {
        razdaljine[i] = 1000000;
    }
    razdaljine[s] = 0;
    cekanje.push(s);

    while (!cekanje.empty()) {
        int trenutni = cekanje.front();
        cekanje.pop();
        if (poseceni[trenutni]) {
            continue;
        }

        poseceni[trenutni] = true;
        for (vector<int>::iterator it = plan[trenutni].begin(); it != plan[trenutni].end(); it++) {
            if (razdaljine[trenutni] + 1 < razdaljine[*it]) {
                razdaljine[*it] = razdaljine[trenutni] + 1;
                cekanje.push(*it);
            }
        }
    }

    cout << razdaljine[t];  
}