#include <iostream>
#include <map>
#include <vector>
#include <string>
#include <queue>
#include <set>

using namespace std;

int brojPresedanjaBFS(const int& start, const int& cilj,
    const map<int, vector<int>>& rute) {
    set<int> posecen;
    queue<pair<int, int>> red;
    red.emplace(start, 0);
    while (!red.empty()) {
        int stanica;
        int broj;
        tie(stanica, broj) = red.front();
        red.pop();
        posecen.insert(stanica);

        auto it = rute.find(stanica);
        if (it != rute.end()) {
            for (const int& s : it->second) {
                if (posecen.find(s) != posecen.end())
                    continue;
                if (s == cilj) {
                    if (broj % 2 == 1) return broj + 1;
                    else continue;
                }

                red.emplace(s, broj + 1);
            }
        }
    }
    return -1;
    
}

int main() {
    ios_base::sync_with_stdio(false); cin.tie(0); cout.tie(0);
    int n, m, start, cilj;
    cin >> n >> m >> start >> cilj;
    map<int, vector<int>> rute;
    for (int i = 0; i < m; i++) {
        int Od, Do;
        cin >> Od >> Do;
        rute[Od].push_back(Do);
        rute[Do].push_back(Od);
    }
    int broj = brojPresedanjaBFS(start, cilj, rute);
    cout << broj / 2 << endl;
    return 0;
}