using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        string[] s = Console.ReadLine().Split();
        int N = int.Parse(s[0]);
        int M = int.Parse(s[1]);
        int S = int.Parse(s[2]);
        int T = int.Parse(s[3]);

        List<int>[] l = new List<int>[N + 1];
        for (int i = 1; i <= N; i++)
        {
            l[i] = new List<int>();
        }

        for (int i = 0; i < M; i++)
        {
            s = Console.ReadLine().Split();
            int U = int.Parse(s[0]);
            int V = int.Parse(s[1]);
            l[U].Add(V);
            l[V].Add(U);
        }

        int r = MinBusCount(l, S, T);
        Console.WriteLine(r);
    }

    static int MinBusCount(List<int>[] list, int start, int target)
    {
        Queue<int> q = new Queue<int>();
        bool[] visited = new bool[list.Length];
        int[] distances = new int[list.Length];

        q.Enqueue(start);
        visited[start] = true;
        distances[start] = 0;

        while (q.Count > 0)
        {
            int current = q.Dequeue();

            foreach (int neighbor in list[current])
            {
                if (!visited[neighbor])
                {
                    q.Enqueue(neighbor);
                    visited[neighbor] = true;
                    distances[neighbor] = distances[current] + 1;

                    if (neighbor == target)
                    {
                        return distances[neighbor] / 2; 
                    }
                }
            }
        }

        return -1;
    }
}