using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        var ulaz = Console.ReadLine().Split().Select(int.Parse).ToArray();
        int brojStanica = ulaz[0], brojLinija = ulaz[1], pocetnaStanica = ulaz[2], ciljnaStanica = ulaz[3];

        var veze = new HashSet<int>[brojStanica + 1];
        for (int i = 0; i <= brojStanica; i++)
            veze[i] = new HashSet<int>();

        for (int i = 0; i < brojLinija; i++)
        {
            var linija = Console.ReadLine().Split().Select(int.Parse).ToArray();
            veze[linija[0]].Add(linija[1]);
            veze[linija[1]].Add(linija[0]);
        }

        var noviGraf = new HashSet<int>[brojStanica + 1];
        for (int i = 0; i <= brojStanica; i++)
            noviGraf[i] = new HashSet<int>();

        for (int i = 1; i <= brojStanica; i++)
        {
            foreach (var prviSused in veze[i])
            {
                foreach (var drugiSused in veze[prviSused])
                {
                    if (i != drugiSused)
                    {
                        noviGraf[i].Add(drugiSused);
                    }
                }
            }
        }

        Console.WriteLine(Bfs(noviGraf, pocetnaStanica, ciljnaStanica));
    }

    static int Bfs(HashSet<int>[] graf, int pocetnaStanica, int ciljnaStanica)
    {
        var red = new Queue<int>();
        var poseteno = new HashSet<int>();
        red.Enqueue(pocetnaStanica);
        poseteno.Add(pocetnaStanica);
        int brojPresedanja = -1;

        while (red.Count > 0)
        {
            int velicinaReda = red.Count;
            brojPresedanja++;
            for (int i = 0; i < velicinaReda; i++)
            {
                int trenutnaStanica = red.Dequeue();

                if (trenutnaStanica == ciljnaStanica) return brojPresedanja;

                foreach (var sused in graf[trenutnaStanica])
                {
                    if (!poseteno.Contains(sused))
                    {
                        red.Enqueue(sused);
                        poseteno.Add(sused);
                    }
                }
            }
        }

        return brojPresedanja;
    }
}