#include <iostream>
#include <vector>
#include <queue>

using namespace std;

const int INF = 1e9;

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;

    vector<vector<int>> adj(N + 1);
    vector<bool> visited(N + 1, false);

    for (int i = 0; i < M; i++) {
        int U, V;
        cin >> U >> V;
        adj[U].push_back(V);
        adj[V].push_back(U);
    }

    vector<int> buses(N + 1, INF);
    buses[S] = 0;

    queue<int> q;
    q.push(S);

    while (!q.empty()) {
        int curr = q.front();
        q.pop();

        for (int next : adj[curr]) {
            if (!visited[next]) {
                visited[next] = true;
                buses[next] = buses[curr] + 1;
                q.push(next);
            }
        }
    }

    if (buses[T] == INF || buses[S] == 0 || buses[T] == 0 || buses[T] == 1) {
        cout << "-1\n";
    } else {
        cout << buses[T] - 2 << "\n";
    }

    return 0;
}