using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        string[] input = Console.ReadLine().Split();
        int N = int.Parse(input[0]);
        int M = int.Parse(input[1]);
        int S = int.Parse(input[2]);
        int T = int.Parse(input[3]);

        List<int>[] adjacencyList = new List<int>[N + 1];
        for (int i = 1; i <= N; i++)
        {
            adjacencyList[i] = new List<int>();
        }

        for (int i = 0; i < M; i++)
        {
            input = Console.ReadLine().Split();
            int U = int.Parse(input[0]);
            int V = int.Parse(input[1]);

            adjacencyList[U].Add(V);
            adjacencyList[V].Add(U);
        }

        int result = MinBuses(adjacencyList, S, T, N);
        Console.WriteLine(result/2);
    }

    static int MinBuses(List<int>[] adjacencyList, int source, int destination, int N)
    {
        Queue<int> queue = new Queue<int>();
        bool[] visited = new bool[N + 1];
        int[] buses = new int[N + 1];

        queue.Enqueue(source);
        visited[source] = true;
        buses[source] = 0;

        while (queue.Count > 0)
        {
            int current = queue.Dequeue();

            if (current == destination)
            {
                return buses[current];
            }

            foreach (int neighbor in adjacencyList[current])
            {
                if (!visited[neighbor])
                {
                    visited[neighbor] = true;
                    buses[neighbor] = buses[current] + 1;
                    queue.Enqueue(neighbor);
                }
            }
        }

        return -1; 
    }
}