#include <iostream>
#include <vector>
#include <queue>
#include <unordered_set>

using namespace std;

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;

    vector<unordered_set<int>> connections(N + 1);
    vector<bool> visited(N + 1, false);
    vector<int> distance(N + 1, -1);

    // ????????? ???????? ????
    for (int i = 0; i < M; ++i) {
        int U, V;
        cin >> U >> V;
        connections[U].insert(V);
        connections[V].insert(U);
    }

    // ?????????????? ?????
    vector<vector<int>> newConnections(N + 1);
    for (int i = 1; i <= N; ++i) {
        for (int a : connections[i]) {
            for (int b : connections[i]) {
                if (a != b) {
                    newConnections[a].push_back(b);
                }
            }
        }
    }

    // BFS ?? ???????? ????????? ????
    queue<int> q;
    q.push(S);
    visited[S] = true;
    distance[S] = 0;

    while (!q.empty()) {
        int current = q.front();
        q.pop();

        if (current == T) {
            break;
        }

        for (int next : newConnections[current]) {
            if (!visited[next]) {
                visited[next] = true;
                distance[next] = distance[current] + 1;
                q.push(next);
            }
        }
    }

    cout << distance[T] << endl;

    return 0;
}