#include <iostream>
#include <list>
using namespace std;

// za svaki cvor pamtimo listu veza
list<int>* veze;

// ukupan broj stanica (unosimo na pocetku programa)
int brojStanica;

// niz koji cuva rastojanja od pocetnog cvora
// po jedan element za svaki cvor
// za pocetni je 0
int* rastojanjeOdPocetnogCvora;


void obidji(int start, bool* obidjeneStanice)
{
	// za trenutni cvor
	// uzmemo sve veze i izracunamo rastojanja od pocetnog cvora
	for (int x : veze[start])
	{
		int v = rastojanjeOdPocetnogCvora[start] + 1;

		// ako prethodni cvor nije jos obidjen (-1) ili je prethodno rastojanje bilo vece, stavimo v kao novo rastojanje
		if (rastojanjeOdPocetnogCvora[x] == -1 || rastojanjeOdPocetnogCvora[x] > v)
			rastojanjeOdPocetnogCvora[x] = v;

	}

	// nakon toga, pozovemo istu rekurentnu funkciju za sve cvorove povezane sa nasim cvorom
	// i obelezimo svaki od njih kao obidjen
	for (int x : veze[start])
	{
		if (!obidjeneStanice[x])
		{
			obidjeneStanice[x] = true;
			obidji(x, obidjeneStanice);
		}
	}
}



int main()
{
	int brojStarihLinija, pocetak, kraj;
	cin >> brojStanica >> brojStarihLinija >> pocetak >> kraj;


	// napravimo listu svih veza
	// posto je graf neusmeren, pamtimo veze u oba smera
	//
	veze = new list<int>[brojStanica + 1];
	for (int i = 0; i < brojStarihLinija; i++)
	{
		int a, b;
		cin >> a >> b;
		veze[a].push_back(b);
		veze[b].push_back(a);
	}


	// pomocni niz gde cuvamo koje su stanice obidjene, a koje ne
	bool* obidjeneStanice = new bool[brojStanica + 1];
	for (int i = 0; i < brojStanica + 1; i++)
	{
		obidjeneStanice[i] = false;
	}

	// kazemo da je rastojanje od pocetka do svakog cvora -1, posto ih jos nismo obisli
	rastojanjeOdPocetnogCvora = new int[brojStanica + 1];
	for (int i = 0; i < brojStanica + 1; i++)
	{
		rastojanjeOdPocetnogCvora[i] = -1;
	}

	// podesimo pocetni cvor
	rastojanjeOdPocetnogCvora[pocetak] = 0;
	obidjeneStanice[pocetak] = true;

	// pozovemo metod za obilazak
	obidji(pocetak, obidjeneStanice);

	// odstampamo rastojanje od pocetnog do krajnjeg cvora podeljeno sa 2 (nacin na koji su stanice menjane, vidi zadatak)
	cout << rastojanjeOdPocetnogCvora[kraj] / 2;


}