from collections import defaultdict, deque

def convert_to_new_plan(N, M, connections):
    new_plan = defaultdict(list)

    for u, v in connections:
        new_plan[u].append(v)
        new_plan[v].append(u)

    return new_plan

def min_buses_to_destination(N, M, S, T, connections):
    new_plan = convert_to_new_plan(N, M, connections)
    
    visited = set()
    queue = deque([(S, 0)]) 

    while queue:
        current_station, buses_taken = queue.popleft()

        if current_station == T:
            return buses_taken

        for next_station in new_plan[current_station]:
            if next_station not in visited:
                visited.add(next_station)
                queue.append((next_station, buses_taken + 1))

    return -1  

N, M, S, T = map(int, input().split())
connections = [tuple(map(int, input().split())) for _ in range(M)]

result = min_buses_to_destination(N, M, S, T, connections)
print(result)