#include <iostream>
#include <vector>
#include <queue>
#include <unordered_set>

using namespace std;

vector<unordered_set<int>> konstruisiNoveStanice(vector<unordered_set<int>>& stareStanice);
int djistra(vector<unordered_set<int>> stanice, int s, int k);


int main()
{
    int n, m, s, k;
    cin >> n >> m >> s >> k;

    vector<unordered_set<int>> stanice(n);
    for (int i = 0; i<m; i++) {
        int sts, stk;
        cin >> sts >> stk;
        stanice[sts-1].insert(stk);
        stanice[stk-1].insert(sts);
    }
    
    stanice = konstruisiNoveStanice(stanice);
    
    cout << djistra(stanice, s, k) << endl;
    return 0;
}

int djistra(vector<unordered_set<int>> stanice, int s, int k)
{
    queue<int> red;
    vector<int> vidjeno(stanice.size()+1);
    
    if (s==k) return 0;

    red.push(s);
    do {
        int tren = red.front();
        int brVidjeno = vidjeno[tren] + 1;
        for (int st: stanice[tren-1]) {
            if (vidjeno[st]) continue;
            if (st == k) return brVidjeno;
            vidjeno[st] = brVidjeno;
            red.push(st);
        }
        red.pop();
    } while (!red.empty());
    return 0;
}

vector<unordered_set<int>> konstruisiNoveStanice(vector<unordered_set<int>>& stareStanice) 
{
    int n = stareStanice.size();
    vector<unordered_set<int>> noveStanice(n);
    for (int i = 0; i<n; i++) {
        for (int st: stareStanice[i])
            for (int stk: stareStanice[st-1])
                if (stk-1 != i)
                    noveStanice[i].insert(stk);
    }
    return noveStanice;
}