#include <stdio.h>

#define MAX_STATIONS 1000

int main() {

    int N, M, S, T;


    scanf("%d %d %d %d", &N, &M, &S, &T);


    int graph[MAX_STATIONS][MAX_STATIONS] = {0};


    for (int i = 0; i < M; ++i) {
        int U, V;
        scanf("%d %d", &U, &V);
        graph[U][V] = 1;
        graph[V][U] = 1; 
        graph[V][U] = 1; // Include this line to handle (V, U) as well
    }

    int queue[MAX_STATIONS];
    int front = 0, rear = 0;

    int visited[MAX_STATIONS] = {0};

    queue[rear++] = S;
    visited[S] = 1;

    int steps = 0;
    while (front < rear) {
        int size = rear - front;
        for (int i = 0; i < size; ++i) {
            int currentStation = queue[front++];
            

            if (currentStation == T) {
                printf("Minimum number of buses: %d\n", steps/2);
                return 0;
            }

            for (int neighbor = 1; neighbor <= N; ++neighbor) {
                if (graph[currentStation][neighbor] && !visited[neighbor]) {
                    queue[rear++] = neighbor;
                    visited[neighbor] = 1;
                }
            }
        }
        steps++; 
    }

    printf("Destination is not reachable.\n");

    return 0;
}