using System;
using System.Collections.Generic;
class Program {
  static void Swap(int[] a, int[] b, int l, int d) {
    int pom = a[l];
    a[l] = a[d];
    a[d] = pom;
    pom = b[l];
    b[l] = b[d];
    b[d] = pom;
    if (a[l] == a[d] && b[d] <= b[l]) {
      pom = b[l];
      b[l] = b[d];
      b[d] = pom;
    }
  }
  static void QuickSort(int[] a, int[] b, int l, int d) {
    if (l < d) {
      Swap(a, b, l, Pivot(a, l, d));
      int p = Particionisanje(a, b, l, d);
      QuickSort(a, b, l, p - 1);
      QuickSort(a, b, p + 1, d);
    }
  }
  static int Pivot(int[] a, int l, int d) {
    Random rnd = new Random();
    return rnd.Next(l, d);
  }
  static int Particionisanje(int[] a, int[] b, int l, int d) {
    int m = l + 1;
    for (int i = l + 1; i <= d; i++) {
      if (a[i] <= a[l])
        Swap(a, b, i, m++);
    }
    Swap(a, b, l, m - 1);
    return m - 1;
  }
  static int Najbliza(int[] a, int S) {
    int l = 0, d = a.Length - 1, s = l + (d - l) / 2;
    while (l <= d) {
      if (S < a[s])
        d = s - 1;
      else if (S > a[s])
        l = s + 1;
      else
        return s;
      s = l + (d - l) / 2;
    }
    return s;
  }
  static int brAutobusa(int[] U, int[] V, int S, int T) {
    int br = 1, i = 0, j = 0;
    while (S < T && (i < V.Length || j < V.Length)) {
      if (U[Najbliza(U, S)] > S)
        i = Najbliza(U, S) - 1;
      if (U[i] != S) {
        j = Najbliza(V, S);
        S = U[i];
        br++;
      }
      while (i < V.Length - 1 && V[i] == U[i + 1] && V[i] < T)
        i++;
      S = V[i];
    }
    while (S > T && (i >= 0 || j >= 0)) {
      if (V[Najbliza(V, S)] < S)
        i = Najbliza(V, S) + 1;
      if (V[i] != S) {
        j = Najbliza(U, S);
        S = V[i];
        br++;
      }
      while (i >= 0 && U[i - 1] == V[i] && U[i] > T)
        i--;
      S = V[i];
    }
    return br;
  }
  public static void Main (string[] args) {
    string[] s = Console.ReadLine().Split();
    int N = int.Parse(s[0].Trim());
    int M = int.Parse(s[1].Trim());
    int S = int.Parse(s[2].Trim());
    int T = int.Parse(s[3].Trim());
    int[] U = new int[M];
    int[] V = new int[M];
    int i;
    for (i = 0; i < M; i++) {
      string[] unos = Console.ReadLine().Split();
      U[i] = int.Parse(unos[0].Trim());
      V[i] = int.Parse(unos[1].Trim());
    }
    QuickSort(U, V, 0, M - 1);
    Console.WriteLine(brAutobusa(U, V, S, T));
  }
}