using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        string[] input = Console.ReadLine().Split();
        int N = int.Parse(input[0]);
        int M = int.Parse(input[1]);
        int S = int.Parse(input[2]);
        int T = int.Parse(input[3]);

        Dictionary<int, List<int>> graph = new Dictionary<int, List<int>>();

        for (int i = 0; i < M; i++)
        {
            input = Console.ReadLine().Split();
            int U = int.Parse(input[0]);
            int V = int.Parse(input[1]);

            if (!graph.ContainsKey(U))
                graph[U] = new List<int>();

            if (!graph.ContainsKey(V))
                graph[V] = new List<int>();

            graph[U].Add(V);
            graph[V].Add(U);
        }

        int result = minimumbuseva(N, graph, S, T);
        Console.WriteLine(result / 2);
    }

    static int minimumbuseva(int N, Dictionary<int, List<int>> graph, int start, int kraj)
    {
        Queue<int> queue = new Queue<int>();
        HashSet<int> visited = new HashSet<int>();

        queue.Enqueue(start);
        visited.Add(start);

        int busevi = 0;

        while (queue.Count > 0)
        {
            int v = queue.Count;

            for (int i = 0; i < v; i++)
            {
                int trenutno = queue.Dequeue();

                if (trenutno == kraj)
                    return busevi;

                foreach (int neighbor in graph[trenutno])
                {
                    if (!visited.Contains(neighbor))
                    {
                        queue.Enqueue(neighbor);
                        visited.Add(neighbor);
                    }
                }
            }

            busevi++;
        }

        return -1;
    }
}