#include <iostream>
#include <vector>
#include <queue>
#include <unordered_set>

using namespace std;

void dodajLiniju(vector<vector<int>>& graf, int a, int b) {
    graf[a].push_back(b);
    graf[b].push_back(a);
}

int najmanjiBrojAutobusa(vector<vector<int>>& graf, int S, int T) {
    vector<int> udaljenost(graf.size(), -1);
    queue<int> red;
    red.push(S);
    udaljenost[S] = 0;

    while (!red.empty()) {
        int trenutnaStanica = red.front();
        red.pop();

        for (int sledecaStanica : graf[trenutnaStanica]) {
            if (udaljenost[sledecaStanica] == -1) {
                udaljenost[sledecaStanica] = udaljenost[trenutnaStanica] + 1;
                red.push(sledecaStanica);

                if (sledecaStanica == T) {
                    return udaljenost[sledecaStanica];
                }
            }
        }
    }

    return -1; // Nije pronaden put do ciljne stanice
}

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;

    vector<vector<int>> stariPlan(N + 1); // Indeksiranje stanica od 1 do N

    for (int i = 0; i < M; i++) {
        int Ui, Vi;
        cin >> Ui >> Vi;
        dodajLiniju(stariPlan, Ui, Vi);
    }

    vector<vector<int>> noviPlan(N + 1);
    unordered_set<int> poseceneStanice;

    for (int i = 1; i <= N; i++) {
        if (i != S) {
            int udaljenost = najmanjiBrojAutobusa(stariPlan, S, i);
            if (udaljenost != -1) {
                dodajLiniju(noviPlan, S, i);
                poseceneStanice.insert(i);
            }
        }
    }

    for (int i = 1; i <= N; i++) {
        if (i != T && poseceneStanice.find(i) == poseceneStanice.end()) {
            int udaljenost = najmanjiBrojAutobusa(stariPlan, T, i);
            if (udaljenost != -1) {
                dodajLiniju(noviPlan, T, i);
            }
        }
    }

    // Ispis rezultata
    int brojLinija = noviPlan[S].size();
    cout << brojLinija << endl;

    return 0;
}