#include <iostream>
#include <algorithm>
#include <vector>
#include <math.h>
#include <string>
#include <map>
#include <queue>
#define ll long long
#define vint vector<int>
#define vll vector<ll>
#define vb vector<bool>
#define vp vector<pair<int, int>>
#define adj_list vector<vector<int>>
#define PB push_back

using namespace std;

void addEdge(adj_list& adj, int root, int child) {
	adj[root].PB(child);
	adj[child].PB(root);
}

int solve(adj_list& adj, int source, int dest, int n) {
	int dist_max = INT_MAX;
	queue<int> q;
	vb visited(n + 1, false);
	vint prev;
	vint distance(n + 1, -1);
	q.push(source);
	distance[source] = 0;
	while (!q.empty()) {
		int u = q.front();
		q.pop();
		visited[u] = true;
		for (int i = 1; i < adj[u].size(); i++) {
			int v = adj[u][i];
			for (int j = 1; j < adj[v].size(); j++) {
				int v1 = adj[v][j];
				if (!visited[v1]) {
					visited[v1] = true;
					q.push(v1);
					distance[v1] = distance[u] + 1;
					if (v1 == dest)
						return distance[v1];
				}
			}
		}
	}
	return distance[dest];
}

int main() {
	int n, m, s, t;
	cin >> n >> m >> s >> t;
	adj_list adj(n + 1);
	for (int i = 1; i <= n; i++)
		adj[i].PB(0);
	int root, child;
	for (int i = 0; i < m; i++) {
		cin >> root >> child;
		addEdge(adj, root, child);
	}
	cout << solve(adj, s, t, n);
}