#include <bits/stdc++.h>

using namespace std;

bool BFS(vector<list<int>>& listaKomsija, int pocetak, int cilj, int brojCvorova, int prethodnici[], int udaljenosti[]) {
    list<int> red;
    bool poseceni[brojCvorova] = {false};

    for (int i = 0; i < brojCvorova; i++) {
        udaljenosti[i] = numeric_limits<int>::max();
        prethodnici[i] = -1;
    }
    poseceni[pocetak] = true;
    udaljenosti[pocetak] = 0;
    red.push_back(pocetak);

    while (!red.empty()) {
        int trenutni = red.front();
        red.pop_front();

        for (int komsija : listaKomsija[trenutni]) {
            if (!poseceni[komsija]) {
                poseceni[komsija] = true;
                udaljenosti[komsija] = udaljenosti[trenutni] + 1;
                prethodnici[komsija] = trenutni;
                red.push_back(komsija);
                if (komsija == cilj)
                    return true;
            }
        }
    }
    return false;
}

void NajkracaUdaljenost(vector<list<int>>& listaKomsija, int pocetak, int cilj, int brojCvorova) {
    int prethodnici[brojCvorova];
    int udaljenosti[brojCvorova];

    if (BFS(listaKomsija, pocetak, cilj, brojCvorova, prethodnici, udaljenosti)) {
        int najkracaUdaljenost = udaljenosti[cilj];
        if(najkracaUdaljenost % 2 == 0)
            cout << najkracaUdaljenost / 2;
        else
            cout << najkracaUdaljenost / 2 + 1;
    }
}

int main() {
    int brojCvorova, brojGrana, pocetak, cilj;
    cin >> brojCvorova >> brojGrana >> pocetak >> cilj;
    vector<list<int>> listaSuseda(brojCvorova+1);

    for (int i = 0; i < brojGrana; i++) {
        int prviCvor, drugiCvor;
        cin >> prviCvor >> drugiCvor;
        listaSuseda[drugiCvor].push_back(prviCvor);
        listaSuseda[prviCvor].push_back(drugiCvor);
    }

    NajkracaUdaljenost(listaSuseda, pocetak, cilj, brojCvorova);
    return 0;
}