#include <stdio.h>
#include <stdlib.h>

#define MAX_NODES 1000
#define MAX_EDGES 1000

typedef struct
{
    int node;
    int depth;
} QueueItem;

int adjacencyMatrix[MAX_NODES][MAX_NODES];
int visited[MAX_NODES];

int bfs(int start, int end, int n)
{
    int i;
    for (i = 1; i <= n; i++) {
        visited[i] = 0;
    }

    QueueItem queue[MAX_NODES];
    int front = 0, rear = 0;

    queue[rear].node = start;
    queue[rear].depth = 0;
    rear++;

    visited[start] = 1;

    while (front < rear)
    {
        QueueItem current = queue[front];
        front++;

        if (current.node == end)
        {
            return current.depth;
        }

        for (i = 1; i <= n; i++)
        {
            if (adjacencyMatrix[current.node][i] == 1 && !visited[i])
            {
                visited[i] = 1;
                queue[rear].node = i;
                queue[rear].depth = current.depth + 1;
                rear++;
            }
        }
    }

    return -1; // Nije pronaden put
}

int main() {
    int N, M, S, T, i, U, V;
    scanf("%d%d%d%d", &N, &M, &S, &T);

    for (i = 0; i < M; i++)
    {
        scanf("%d%d", &U, &V);
        adjacencyMatrix[U][V] = 1;
        adjacencyMatrix[V][U] = 1;
    }

    int result = bfs(S, T, N)/2;

    printf("%d", result);

    return 0;
}