#include <iostream>
#include <list>
#include <queue>
#include <cstring>
using namespace std;

void newGraph(list<int> g[], list<int> g1[], int n) {
  for (int i=0; i<n; i++) {
    for (int j : g[i]) {
      for (int k : g[j]) {
        if (i != k) g1[i].push_back(k);
      }
    }
  }
}

int bfs(list<int> g[], int n, int s, int t) {
  int visited[n];
  int distance[n];
  queue<int> q;

  for (int i=0; i<n; i++) {
    visited[i] = 0;
    distance[i] = 0;
  }

  q.push(s);
  visited[s] = true;
  distance[s] = 0;

  while (!q.empty()) {
    int i = q.front(); q.pop();
    for (auto j : g[i]) {
      if (!visited[j]) {
        q.push(j);
        visited[j] = true;
        distance[j] = distance[i] + 1;
      }
    }
  }
  
  return distance[t];
}

int main() {
  int n, m, s, t, u, v;
  scanf("%d %d %d %d", &n, &m, &s, &t);
  list<int> g[n], g1[n];
  for (int i=0; i<m; i++) {
    scanf("%d %d", &u, &v);
    u--; v--;
    g[u].push_front(v);
    g[v].push_front(u);
  }
  s--; t--;

  newGraph(g, g1, n);
  printf("%d", bfs(g1, n, s, t));
  return 0;
}