#include <iostream>
#include <list>
#include <queue>
#include <cstring>
using namespace std;

int bfs(list<int> g[], int n, int s, int t) {
  int visited[n];
  int distance[n];
  queue<int> q;
  q.push(s);
  visited[s] = true;
  for (int i=0; i<n; i++) {
    visited[i] = 0;
    distance[i] = 0;
  }

  while (!q.empty()) {
    int i = q.front(); q.pop();
    for (auto j : g[i]) {
      for (auto k : g[j]) {
        if (visited[k] || k == j) continue;
        q.push(k);
        visited[k] = true;
        distance[k] = distance[i]+1;
      }
    }
  }
  return distance[t];
}

int main() {
  int n, m, s, t, u, v;
  scanf("%d %d %d %d", &n, &m, &s, &t);
  list<int> g[n];
  for (int i=0; i<m; i++) {
    scanf("%d %d", &u, &v);
    u--; v--;
    g[u].push_front(v);
    g[v].push_front(u);
  }

  s--; t--;
  printf("%d", bfs(g, n, s, t)-1);
}