using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApp21
{
    internal class Program
    {


        static int bfs(Dictionary<int, List<int>> graf, int s, int t)
        {
            Queue<int> red = new Queue<int>();
            HashSet<int> posetio = new HashSet<int>();
            red.Enqueue(s);
            posetio.Add(s);

            int brojAutobusa = 0;

            while (red.Count > 0)
            {
                int velicina = red.Count;

                for (int i = 0; i < velicina; i++)
                {
                    int trenutnaStanica = red.Dequeue();

                    if (trenutnaStanica == t)
                        return brojAutobusa;

                    foreach (int susednaStanica in graf[trenutnaStanica])
                    {
                        if (!posetio.Contains(susednaStanica))
                        {
                            red.Enqueue(susednaStanica);
                            posetio.Add(susednaStanica);
                        }
                    }
                }

                brojAutobusa++;
            }

            return -1; 
        }

        static void Main(string[] args)
        {
            int[] a = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse);
            int n = a[0];
            int m = a[1];
            int s = a[2];
            int t = a[3];

            Dictionary<int, List<int>> graf = new Dictionary<int, List<int>>();

            for (int i = 0; i < m; i++)
            {
                a = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse);

                if (!graf.ContainsKey(a[0]))
                    graf[a[0]] = new List<int>();

                if (!graf.ContainsKey(a[1]))
                    graf[a[1]] = new List<int>();

                graf[a[0]].Add(a[1]);
                graf[a[1]].Add(a[0]);
            }

            Console.WriteLine(bfs(graf, s, t));
            Console.ReadLine();
        }
    }
}