using System;
using System.Collections.Generic;
using System.Diagnostics;
class Graf
{
    private int V;
    private List<int>[] Lista;

    public Graf(int brojcvorova)
    {
        V = brojcvorova;
        Lista = new List<int>[V];

        for (int i = 0; i < V; i++)
        {
            Lista[i] = new List<int>();
        }
    }

    public void cvorovi(int iz, int u)
    {
        Lista[iz].Add(u);
    }
    public int najkraciput(int pocetak, int kraj)
    {
        int[] put = new int[V];
        bool[] vecbio = new bool[V];
        int[] red = new int[V];
        int a = 0, b = 0;

        for (int i = 0; i < V; i++)
        {
            put[i] = int.MaxValue;
            vecbio[i] = false;
        }

        put[pocetak] = 0;
        vecbio[pocetak] = true;
        red[b++] = pocetak;

        while (a != b)
        {
            int u = red[a++];

            foreach (var susedni in Lista[u])
            {
                if (!vecbio[susedni])
                {
                    vecbio[susedni] = true;
                    put[susedni] = put[u] + 1;
                    red[b++] = susedni;
                }
            }
        }

        return put[kraj];
    }
}

class Program
{
    static void Main(string[] args)
    {
        int N, M, S, T;
        string[] s = Console.ReadLine().Split();
        N = int.Parse(s[0]);
        M = int.Parse(s[1]);
        S = int.Parse(s[2]);
        T = int.Parse(s[3]);
        int[,] stari = new int[N, N];
        int[,] novi = new int[N, N];
        for (int i = 0; i < M; i++)
        {
            s = Console.ReadLine().Split();
            stari[int.Parse(s[0]) - 1, int.Parse(s[1]) - 1] = 1;
            stari[int.Parse(s[1]) - 1, int.Parse(s[0]) - 1] = 1;
        }
        for (int i = 0; i < N; i++)
        {
            for (int j = 0; j < N; j++)
            {
                if (stari[i, j] == 1)
                {
                    for (int k = 0; k < N; k++)
                    {
                        if (stari[j, k] == 1 && k != i)
                            novi[i, k] = 1;
                    }
                }
            }
        }
        Graf graf = new Graf(N);
        for (int i = 0; i < N; i++)
        {
            for (int j = 0; j < N; j++)
            {
                if (novi[i, j] == 1)
                {
                    graf.cvorovi(i, j);
                }
            }
        }
        Console.WriteLine(graf.najkraciput(S - 1, T - 1));
    }
}