#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>
#include <limits>
#include <cstdlib>

using namespace std;

struct Cvor {
    int a;
};
struct Put {
    Cvor cvor1;
    Cvor cvor2;
};

int bfs(const vector<Put>& putevi, int start, int target) {
    vector<bool> visited(100001, false);
    vector<int> dist(100001, numeric_limits<int>::max());

    queue<int> q;
    q.push(start);
    dist[start] = 0;
    visited[start] = true;

    while (!q.empty()) {
        int current = q.front();
        q.pop();

        for (const Put& put : putevi) {
            if (put.cvor1.a == current && !visited[put.cvor2.a]) {
                q.push(put.cvor2.a);
                visited[put.cvor2.a] = true;
                dist[put.cvor2.a] = dist[current] + 1;
            } else if (put.cvor2.a == current && !visited[put.cvor1.a]) {
                q.push(put.cvor1.a);
                visited[put.cvor1.a] = true;
                dist[put.cvor1.a] = dist[current] + 1;
            }
        }
    }

    return dist[target];
}

int main() {
    unsigned long long int n, m;
    cin >> n >> m;
    if(n<3||m<3){
        exit(0);
    }
    else if(n>500000||m>500000){
        exit(0);
    }
    else{

    Cvor s; 
    Cvor t;
    cin >> s.a >> t.a;

    vector<Put> putevi(m);
    vector<Put> noviPutevi;

    for (unsigned long long int i = 0; i < m; ++i) {
        cin >> putevi[i].cvor1.a >> putevi[i].cvor2.a;
    }

    int x = 1;
    int brojac1 = 0;
    int brojac2 = 0;
    int brojac3 = 0;
    int brojac4 = 0;

    for (unsigned long long int j = 0; j < m - 1; j += 1) {
        for (vector<Put>::iterator it = putevi.begin(); it != putevi.end(); ++it) {
            const Put& put = *it;

            if (put.cvor1.a == (it + x)->cvor1.a) {
                Put noviPut;
                noviPut.cvor1.a = put.cvor2.a;
                noviPut.cvor2.a = (it + x)->cvor2.a;
                noviPutevi.push_back(noviPut);
                brojac1++;
            } else if (put.cvor2.a == (it + x)->cvor2.a) {
                Put noviPut;
                noviPut.cvor1.a = put.cvor1.a;
                noviPut.cvor2.a = (it + x)->cvor1.a;
                noviPutevi.push_back(noviPut);
                brojac2++;
            } else if (put.cvor1.a == (it + x)->cvor2.a) {
                Put noviPut;
                noviPut.cvor1.a = (it + x)->cvor1.a;
                noviPut.cvor2.a = put.cvor2.a;
                noviPutevi.push_back(noviPut);
                brojac3++;
            } else if (put.cvor2.a == (it + x)->cvor1.a) {
                Put noviPut;
                noviPut.cvor1.a = put.cvor1.a;
                noviPut.cvor2.a = (it + x)->cvor2.a;
                noviPutevi.push_back(noviPut);
                brojac4++;
            }
        }
        x++;
    }

    putevi.insert(putevi.end(), noviPutevi.begin(), noviPutevi.end());

    //cout << "\n";
    /*for (unsigned long long int i = 0; i < putevi.size(); ++i) {
        cout << putevi[i].cvor1.a << " " << putevi[i].cvor2.a << "\n";
    }*/

    int minEdges = bfs(putevi, s.a, t.a);
    cout << minEdges << endl;

    return 0;
    }
}