#include <iostream>
#include <set>
#include <algorithm>
#include <queue>

struct podaci_o_stanici {
    std::set<int> povezane_stanice;
};

int bfs(podaci_o_stanici* arr, int broj_stanica, int broj_ivica, int pocetna_stanica, int trazeno) {
    int trenutno;
    int razdaljina;
    int i;
    std::set<int> posecene;
    std::queue<std::pair<int, int>> q;
    q.push({pocetna_stanica, 0});

    while (!q.empty()) {
        trenutno = q.front().first;
        razdaljina = q.front().second;
        q.pop();
        
        if (trenutno==trazeno) {
            return razdaljina; 
        }

        if (posecene.find(trenutno)==posecene.end()) {
            posecene.insert(trenutno);
            
            for (const auto& stanica_i : arr[trenutno].povezane_stanice) {
                for (const auto& stanica_j : arr[stanica_i].povezane_stanice) {
                    if (arr[stanica_i].povezane_stanice.find(stanica_j)!=arr[trenutno].povezane_stanice.end()) {
                        q.push({stanica_j, razdaljina+1});
                        posecene.insert(trenutno);
                    }
                }
            }
        }
    }

    return -1;
}


int main() {
    int n, m;
    int s, t;
    int i, j;
    int a, b;
    int rez;

    std::cin >> n;
    std::cin >> m;
    std::cin >> s;
    std::cin >> t;
    podaci_o_stanici *linije = new podaci_o_stanici[n];

    s--;
    t--;

    for (i=0; i<m; i++) {
        std::cin >> a;
        std::cin >> b;

        a--;
        b--;

        linije[a].povezane_stanice.insert(b);
        linije[b].povezane_stanice.insert(a);
    }

    rez=bfs(linije, n, m, s, t);

    std::cout<<rez;

    delete[] linije;

    return 0;
}