#define _CRT_DISABLE_PERFCRIT_LOCKS
#define _CRT_SECURE_NO_WARNINGS
#define FASTIO ios_base::sync_with_stdio(false); cin.tie(NULL)
#define ll long long

#include <iostream>
#include <vector>
#include <map>
#include <list>
#include <queue>
using namespace std;

list<pair<int, int>>* adj = {};

bool vechas(vector<int> vec, int val)
{
    for (int i = 0; i < vec.size(); i++)
    {
        if (vec[i] == val) return true;
    }
    return false;
}

void shortestPath(int src, int broj, int terminal)
{
    priority_queue<pair<int, int>, vector<pair<int, int>>, greater<pair<int, int>>>
        pq;
    vector<int> dist(broj, 0x3f3f3f3f);

    pq.push(make_pair(0, src));
    dist[src] = 0;

    while (!pq.empty()) {

        int u = pq.top().second;
        pq.pop();

        list<pair<int, int> >::iterator i;
        for (i = adj[u].begin(); i != adj[u].end(); ++i) {

            int v = (*i).first;
            int weight = (*i).second;

            if (dist[v] > dist[u] + weight) {
                dist[v] = dist[u] + weight;
                pq.push(make_pair(dist[v], v));
            }
        }
    }

    printf("%d", dist[terminal]);
}

int main()
{
    FASTIO;
    map<int, vector<int>> staramapa;
    map<int, vector<int>> novamapa;
    int brojstanica, brojparova, pocetna, terminal;

    scanf("%d %d %d %d", &brojstanica, &brojparova, &pocetna, &terminal);

    for (int i = 0; i < brojstanica; i++)
    {
        staramapa.insert(make_pair(i, vector<int>()));
        novamapa.insert(make_pair(i, vector<int>()));
    }

    for (int i = 0; i < brojparova; i++)
    {
        int par1, par2;
        scanf("%d %d", &par1, &par2);
        staramapa[par1 - 1].push_back(par2 - 1);
        staramapa[par2 - 1].push_back(par1 - 1);
    }

    for (int i = 0; i < brojstanica; i++)
    {
        for (int j = 0; j < staramapa[i].size(); j++)
        {
            for (int k = j + 1; k < staramapa[i].size(); k++)
            {
                if (!vechas(novamapa[staramapa[i][j]], staramapa[i][k]) && !vechas(novamapa[staramapa[i][k]], staramapa[i][j])) novamapa[staramapa[i][j]].push_back(staramapa[i][k]);
            }
        }
    }

    adj = new list<pair<int, int>>[brojstanica];

    for (int i = 0; i < brojstanica; i++)
    {
        for (int j = 0; j < novamapa[i].size(); i++)
        {
            adj[i].push_back(make_pair(novamapa[i][j], 1));
            adj[novamapa[i][j]].push_back(make_pair(i, 1));
        }
    }

    shortestPath(pocetna - 1, brojstanica, terminal - 1);
    
}