#include <iostream>
#include <vector>
#include <queue>

using namespace std;

int minBrojAutobusa(int N, int M, int S, int T, vector<pair<int, int>>& veze) {
    vector<vector<int>> graf(N + 1);
    vector<bool> poseceno(N + 1, false);
    vector<int> prethodnaSt(S + 1, -1);

    for (int i = 0; i < M; i++) {
        int U = veze[i].first;
        int V = veze[i].second;
        graf[U].push_back(V);
        graf[V].push_back(U);
    }

    queue<int> red;
    red.push(S);
    poseceno[S] = true;

    while (!red.empty()) {
        int trenutnaStanica = red.front();
        red.pop();

        for (int sused : graf[trenutnaStanica]) {
            if (!poseceno[sused]) {
                red.push(sused);
                poseceno[sused] = true;
                prethodnaSt[sused] = trenutnaStanica;
            }
        }
    }

    int brojacAutobusa = 0;
    int trenutnaStanica = T;

    while (prethodnaSt[trenutnaStanica] != -1) {
        brojacAutobusa++;
        trenutnaStanica = prethodnaSt[trenutnaStanica];
    }

    return brojacAutobusa;
}

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;

    vector<pair<int, int>> veze(M);
    for (int i = 0; i < M; i++) {
        int U, V;
        cin >> U >> V;
        veze[i] = make_pair(U, V);
    }

    int rezultat = minBrojAutobusa(N, M, S, T, veze);
    cout << rezultat << endl;

    return 0;
}