#include <stdio.h>
#include <stdlib.h>
#define MAX_N 200000
#define MAX_M 200000

typedef struct 
{
    int *cv;
    int v;
    int k;
} L;

typedef struct 
{
    int *r;
    int p;
    int q;
    int k;
} Q;

void initL(L *l, int k) 
{
    l->cv = (int *)malloc(k * sizeof(int));
    l->v = 0;
    l->k = k;
}

void addC(L *l, int c) 
{
    if (l->v == l->k) 
    {
        l->k *= 2;
        l->cv = (int *)realloc(l->cv, l->k * sizeof(int));
    }
    l->cv[l->v++] = c;
}

void initQ(Q *q, int k) 
{
    q->r = (int *)malloc(k * sizeof(int));
    q->p = 0;
    q->q = -1;
    q->k = k;
}

void enQ(Q *q, int e) 
{
    if (q->q == q->k - 1) 
    {
        q->k *= 2;
        q->r = (int *)realloc(q->r, q->k * sizeof(int));
    }
    q->r[++q->q] = e;
}

int deQ(Q *q) 
{
    int e = q->r[q->p++];
    if (q->p == q->k) {
        q->p = 0;
    }
    return e;
}

int minBA(L *g, int N, int S, int T);

int main() 
{
    int N, M, S, T;
    scanf("%d %d %d %d", &N, &M, &S, &T);
    L *g = (L *)malloc((N + 1) * sizeof(L));
    for (int i = 0; i <= N; i++) {
        initL(&g[i], 2);
    }
    for (int i = 0; i < M; i++) 
    {
        int U, V;
        scanf("%d %d", &U, &V);
        addC(&g[U], V);
        addC(&g[V], U);
    }
    int res = minBA(g, N, S, T);
    printf("%d\n", res / 2);
    for (int i = 0; i <= N; i++) 
    {
        free(g[i].cv);
    }
    free(g);
    return 0;
}
int minBA(L *g, int N, int S, int T) 
{
    int *p = (int *)malloc((N + 1) * sizeof(int));
    for (int i = 0; i <= N; i++) {
        p[i] = 0;
    }
    Q q;
    initQ(&q, MAX_N);
    enQ(&q, S);
    p[S] = 1;
    int bA = 0;
    while (q.p != q.q + 1) 
    {
        int l = q.q - q.p + 1;

        for (int i = 0; i < l; i++) 
        {
            int t = deQ(&q);

            if (t == T) 
            {
                free(p);
                free(q.r);
                return bA;
            }

            for (int j = 0; j < g[t].v; j++) 
            {
                int s = g[t].cv[j];
                if (!p[s]) 
                {
                    enQ(&q, s);
                    p[s] = 1;
                }
            }
        }

        bA++;
    }
    free(p);
    free(q.r);
    return -1;
}