#include <stdio.h>
#include <stdlib.h>
#define MAX_N 200000
#define MAX_M 200000

typedef struct 
{
    int *susedi;
    int velicina;
    int kapacitet;
} Lista;

typedef struct 
{
    int *red;
    int pocetak;
    int kraj;
    int kapacitet;
} Red;

void inicijalizujListu(Lista *lista, int kapacitet) 
{
    lista->susedi = (int *)malloc(kapacitet * sizeof(int));
    lista->velicina = 0;
    lista->kapacitet = kapacitet;
}

void dodajSuseda(Lista *lista, int sused) 
{
    if (lista->velicina == lista->kapacitet) 
    {
        lista->kapacitet *= 2;
        lista->susedi = (int *)realloc(lista->susedi, lista->kapacitet * sizeof(int));
    }
    lista->susedi[lista->velicina++] = sused;
}

void inicijalizujRed(Red *red, int kapacitet) 
{
    red->red = (int *)malloc(kapacitet * sizeof(int));
    red->pocetak = 0;
    red->kraj = -1;
    red->kapacitet = kapacitet;
}

void dodajURed(Red *red, int element) 
{
    if (red->kraj == red->kapacitet - 1) 
    {
        red->kapacitet *= 2;
        red->red = (int *)realloc(red->red, red->kapacitet * sizeof(int));
    }
    red->red[++red->kraj] = element;
}

int izbaciIzReda(Red *red) 
{
    int element = red->red[red->pocetak++];
    if (red->pocetak == red->kapacitet) {
        red->pocetak = 0;
    }
    return element;
}

int najmanjiBrojAutobusa(Lista *graf, int N, int S, int T);

int main() 
{
    int N, M, S, T;
    scanf("%d %d %d %d", &N, &M, &S, &T);
    
    Lista *graf = (Lista *)malloc((N + 1) * sizeof(Lista));
    for (int i = 0; i <= N; i++) {
        inicijalizujListu(&graf[i], 2);
    }

    for (int i = 0; i < M; i++) 
    {
        int U, V;
        scanf("%d %d", &U, &V);
        dodajSuseda(&graf[U], V);
        dodajSuseda(&graf[V], U);
    }

    int rezultat = najmanjiBrojAutobusa(graf, N, S, T);
    printf("%d\n", rezultat / 2);

    for (int i = 0; i <= N; i++) 
    {
        free(graf[i].susedi);
    }
    free(graf);

    return 0;
}

int najmanjiBrojAutobusa(Lista *graf, int N, int S, int T) 
{
    int *poseceno = (int *)malloc((N + 1) * sizeof(int));
    for (int i = 0; i <= N; i++) {
        poseceno[i] = 0;
    }

    Red red;
    inicijalizujRed(&red, MAX_N);
    dodajURed(&red, S);
    poseceno[S] = 1;

    int brojAutobusa = 0;

    while (red.pocetak != red.kraj + 1) 
    {
        int velicinaNivoa = red.kraj - red.pocetak + 1;

        for (int i = 0; i < velicinaNivoa; i++) 
        {
            int trenutni = izbaciIzReda(&red);

            if (trenutni == T) 
            {
                free(poseceno);
                free(red.red);
                return brojAutobusa;
            }

            for (int j = 0; j < graf[trenutni].velicina; j++) 
            {
                int sused = graf[trenutni].susedi[j];
                if (!poseceno[sused]) 
                {
                    dodajURed(&red, sused);
                    poseceno[sused] = 1;
                }
            }
        }

        brojAutobusa++;
    }

    free(poseceno);
    free(red.red);
    return -1;
}