#include <iostream>
#include <queue>
#include <vector>
using namespace std;

#define MAX 200005

int s, e, n, m;

void dijkstra(const vector<vector<int>>& graf, vector<bool>& seen, vector<int>& d) {
  priority_queue<
    pair<int, int>,
    vector<pair<int, int>>,
    greater<pair<int, int>>
  > q;
  q.push({0, s});

  while(!q.empty()) {
    int dist = q.top().first;
    int v = q.top().second;
    q.pop();

    if(seen[v]) continue;
    seen[v] = 1;
    d[v] = dist;

    for(int i=0; i<graf[v].size(); ++i) {
      if(!seen[graf[v][i]]) {
        q.push({dist+1, graf[v][i]});
      }
    }
  }
}

int main(void) {
  cin >> n >> m >> s >> e;
  vector<vector<int>> graf(n);
  --e;
  --s;

  int u, v;
  for(int i=0; i<m; ++i) {
    cin >> u >> v;
    --u;
    --v;
    graf[u].push_back(v);
    graf[v].push_back(u);
  }

  vector<bool> seen(n, false);
  vector<int> d(n, 0);

  dijkstra(graf, seen, d);

  cout << ((d[e-1] % 2 == 0) ? d[e-1] / 2 : (d[e-1]-1) / 2 + 1);

  return 0;
}