import heapq

def dijkstra(graph, start, end):
    distances = {node: float('infinity') for node in graph}
    distances[start] = 0
    priority_queue = [(0, start)]

    while priority_queue:
        current_distance, current_node = heapq.heappop(priority_queue)

        if current_node == end:
            return distances[end]

        if current_distance > distances[current_node]:
            continue

        for neighbor in graph[current_node]:
            distance = current_distance + 1  
            if distance < distances[neighbor]:
                distances[neighbor] = distance
                heapq.heappush(priority_queue, (distance, neighbor))

    return float('infinity')


N, M, S, T = map(int, input().split())
graph = {i: set() for i in range(1, N + 1)}

for _ in range(M):
    Ui, Vi = map(int, input().split())
    graph[Ui].add(Vi)
    graph[Vi].add(Ui)


result = dijkstra(graph, S, T)
print(result//2)