using System;
using System.Runtime.CompilerServices;
using System.Collections.Generic;

class program
{
    static void dodaj(Dictionary<int,List<int>> povezane_stanice,HashSet<int> stanice)
    {
        foreach (var x in stanice)
        {
            if (!povezane_stanice.ContainsKey(x))
            {
                povezane_stanice[x] = new List<int>();
            }

            povezane_stanice[x].AddRange(stanice);
            povezane_stanice[x].Remove(x);

        }
    }
    static int CalculateBusesNeeded(Dictionary<int, List<int>> connectedStations, int start, int end)
    {
        Queue<int> queue = new Queue<int>();
        HashSet<int> visited = new HashSet<int>();
        Dictionary<int, int> busesCount = new Dictionary<int, int>();

        queue.Enqueue(start);
        busesCount[start] = 0;
        visited.Add(start);

        while (queue.Count > 0)
        {
            int current = queue.Dequeue();

            if (current == end)
            {
                return busesCount[current];
            }

            foreach (var neighbor in connectedStations[current])
            {
                if (!visited.Contains(neighbor))
                {
                    queue.Enqueue(neighbor);
                    visited.Add(neighbor);
                    busesCount[neighbor] = busesCount[current] + 1;
                }
            }
        }

        return -1;
    }

    static void Main()
    {
        Dictionary<int,HashSet<int>> parovi= new Dictionary<int, HashSet<int>>();
        Dictionary<int,List<int>> povezane= new Dictionary<int, List<int>>();
        
        string[] s = Console.ReadLine().Split();
        int N = int.Parse(s[0]);
        int M = int.Parse(s[1]);
        int S = int.Parse(s[2]);
        int T = int.Parse(s[3]);

        for(int i = 0; i < M;i++ )
        {
            s = Console.ReadLine().Split();
            int U = int.Parse(s[0]);
            int V = int.Parse(s[1]);
            
            if (!parovi.ContainsKey(U))
            {
                parovi.Add(U, new HashSet<int>());
            }
            if (!parovi.ContainsKey(V))
            {
                parovi.Add(V, new HashSet<int>());
            }
            parovi[U].Add(V);
            parovi[V].Add(U);
        }
       
        foreach(var x in parovi.Values)
        {
            dodaj(povezane, x);
        }

        Console.WriteLine(CalculateBusesNeeded(povezane, S, T));
       
        
    }
}