#include <iostream>
#include <vector>
#include <queue>
#include <limits>

using namespace std;

const int INF = numeric_limits<int>::max();

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;

    // Graf predstavljen matricom povezanosti
    vector<vector<int>> graph(N + 1, vector<int>(N + 1, 0));

    for (int i = 0; i < M; ++i) {
        int U, V;
        cin >> U >> V;
        graph[U][V] = graph[V][U] = 1; // postavljanje veze izmedu stanica
    }

    // BFS za traženje najmanjeg broja presedanja
    vector<int> distance(N + 1, INF);
    queue<int> q;

    distance[S] = 0;
    q.push(S);

    while (!q.empty()) {
        int current = q.front();
        q.pop();

        for (int neighbor = 1; neighbor <= N; ++neighbor) {
            if (graph[current][neighbor] && distance[neighbor] == INF) {
                distance[neighbor] = distance[current] + 1;
                q.push(neighbor);
            }
        }
    }

    // Ispis rezultata
   
        cout << distance[T] << endl;
    

    return 0;
}